﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace ConsoleApplication1
{
    class Program
    {
        static void Main(string[] args)
        {
           
        }
    }
    class ElementUDokumentu
    {
        private string vrsta;

        public string Vrsta
        {
            get { return vrsta; }
            set { vrsta = value; }
        }

        public ElementUDokumentu(string vrsta)
        {
            this.vrsta = vrsta;
        }

        public override string ToString()
        {
            return vrsta;
        }
    }
    class Recenica : TekstualniElement
    {
        private string tekst;

        public string Tekst
        {
            get { return tekst; }
            set { tekst = value; }
        }

        public Recenica(string tekst) : base("recenica")
        {
            char poslednji = tekst.Last();

            if (poslednji == '.')
            {
                this.tekst = tekst.Remove(tekst.Length - 1, 1);
            }
        }

        public override string GetText()
        {
            return tekst + ".";
        }

        public override string ToString()
        {
            return Vrsta + ": " + tekst;
        }
    }
    abstract class TekstualniElement : ElementUDokumentu
    {
        public TekstualniElement(string vrsta) : base(vrsta)
        {

        }

        public abstract string GetText();
    }
    class Paragraf : TekstualniElement
    {
        private StringBuilder tekst;

        public StringBuilder Tekst
        {
            get { return tekst; }
            set { tekst = value; }
        }

        public Paragraf(string tekst) : base("paragraf")
        {
            int pozicijaNoveLinije = nadjiNovuLiniju(tekst);

            DodajTekst(tekst.Remove(pozicijaNoveLinije));
        }

        public Paragraf(Recenica recenica) : base("paragraf")
        {
            DodajTekst(recenica);
        }

        public void DodajTekst(string tekst)
        {
            this.tekst.Append(tekst);
        }

        public void DodajTekst(Recenica recenica)
        {
            tekst.Append(recenica.Tekst);
        }

        public override string GetText()
        {
            tekst.Append('\n');

            return tekst.ToString();
        }

        private int nadjiNovuLiniju(string tekst)
        {
            for (int i = 0; i < tekst.Length; i++)
            {
                if (tekst[i].Equals('\n'))
                {
                    return i - 1;
                }
            }

            return tekst.Length - 1;
        }
    }

    class GrafickiElement : ElementUDokumentu
    {
        private string nazivBoje;

        public GrafickiElement(string vrsta, string nazivBoje) : base(vrsta)
        {
            this.nazivBoje = nazivBoje;
        }

        public string NazivBoje
        {   get { return nazivBoje; }
            set { nazivBoje = value; }
        }
    }


    class Dokument
    {
        private List<GrafickiElement> grafickiElementi;
        private List<TekstualniElement> tekstualniElementi;

        public void AddElement(GrafickiElement grafickiElement)
        {
            grafickiElementi.Add(grafickiElement);
        }

        public void AddElement(TekstualniElement tekstualniElement)
        {
            tekstualniElementi.Add(tekstualniElement);
        }

        public void PrintText()
        {
            foreach (TekstualniElement te in tekstualniElementi)
            {
                Console.WriteLine(te.GetText());
            }
        }

        public List<TekstualniElement> GetTextElements()
        {
            return tekstualniElementi;
        }

        public override string ToString()
        {
            StringBuilder temp = new StringBuilder();

            foreach (TekstualniElement te in tekstualniElementi)
            {
                temp.Append(te.ToString());
                temp.AppendLine();
            }

            foreach (GrafickiElement ge in grafickiElementi)
            {
                temp.Append(ge.ToString());
                temp.AppendLine();
            }

            return temp.ToString();
        }
    }

    class Pravougaonik : GrafickiElement
    {
        private int x1;
        private int y1;
        private int x2;
        private int y2;

        private Pravougaonik(string boja, int x1, int y1, int x2, int y2) : base("pravugaonik", boja)
        {
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
        }

        public int X1
        {
            get { return x1; }
            set { x1 = value; }
        }
        public int Y1
        {
            get { return y1; }
            set { y1 = value; }
        }
        public int X2
        {
            get { return x2; }
        set { x2 = value; }
        }
        public int Y2
        {
            get { return y2; }
            set { y2 = value; }
        }

        public override string ToString()
        {
            return String.Format("{0}(({1},{2}),{3},{4})", NazivBoje, x1, y1, x2 - x1, y2 - y1);
        }
    }



}
